<?php
	//BUILD QUERY
if (!function_exists('pw_fetch_ticker_cat_items')) {
	add_action('wp_ajax_pw_fetch_ticker_cat_items', 'pw_fetch_ticker_cat_items');
	add_action('wp_ajax_nopriv_pw_fetch_ticker_cat_items', 'pw_fetch_ticker_cat_items');
	function pw_fetch_ticker_cat_items()
	{
		global $wpdb;

		parse_str($_REQUEST['postdata'], $my_array_of_vars);

		$nonce = $_POST['nonce'];

		if (!wp_verify_nonce($nonce, 'pl_news_ticker')) {
			$arr = array(
				'success' => 'no-nonce',
				'products' => array()
			);
			print_r($arr);
			die();
		}

		extract(shortcode_atts(array(
			'ticker_soure' => 'build_query',
			'ticker_base' => 'all',
			'pw_query' => '',
			'rss_source' => '',
			'set_rss_image' => 'hide_rss_image',
			'rss_images' => '',
			'manual_source' => '',


			//ticker setting tab
			'ticker_mode' => 'pl-horizontal-ticker',
			'vertical_item_layout' => 'pl-vitem-layout-1',
			'ticker_height' => '50',
			'enable_interval' => 'disable_interval',
			'ticker_interval' => '10',
			'enable_rtl' => 'pl-ltr-ticker',
			'ticker_pos' => 'pl-current-wrapper',
			'hide_title' => 'show_title',
			'title_text' => 'Breaking News',
			'title_width' => '150',
			'title_icon' => 'fa-none',
			'show_filter' => 'hide_filter',

			'show_author_image' => 'hide_author_image',
			'show_time' => 'pl-timer-disable',
			'show_toggle' => 'hide_toggle',
			'show_post_image' => 'hide_post_image',
			'post_image_style' => 'pl-round-img',
			'default_image' => '',

			'show_date' => 'hide_date',
			'date_format' => 'j F Y',

			'show_sharing' => 'hide_date',
			'social_icons' => '',

			'show_quick' => 'hide_quick',
			'quick_effect' => 'fade-in-scale',

			'show_meta' => 'no',
			'show_author' => 'no',
			'show_comments' => 'no',
			'show_category' => 'no',
			'cat_number' => '1',

			'show_excerpt' => 'no',
			'excerpt_source' => 'excerpt',
			'excerpt_len' => '20',


			//carousel setting
			'carousel_effect' => 'slide',
			'marquee_direction' => 'left',
			'scroll_amount' => '20',
			'marquee_height' => '200',
			'show_navigation' => 'pl-ticker-hide-nav',
			'auto_speed' => '2000',
			'trans_speed' => '2000',
			'item_per_show' => '3',
			'item_per_slide' => '1',


			//Style Tab

			'ticker_border' => '0,0,0,0,solid,#dddddd',
			'toggle_background' => '#444',
			'toggle_color' => '#fff',

			'title_background' => '#444444',
			'title_font' => 'inherit,15,#ffffff',
			'title_layout' => 'pl-ticker-title-l1',

			'clock_background' => '#333333',
			'clock_font' => 'inherit,15,#f5f5f5',

			'content_background' => '#777777',
			'content_font' => 'inherit,15,#f5f5f5,#f5f5f5',
			'meta_font' => 'inherit,11,#f5f5f5,#f5f5f5',
			'icon_background' => '#444444',
			'icon_color' => '#ffffff',

			'nav_background' => '#444',
			'nav_color' => '#fff',

			'custom_css' => '',
			'user_css' => '',
		), json_decode($my_array_of_vars['pw_atts'])));

		//print_r(json_decode($my_array_of_vars['pw_atts']));

		$rand_id = $my_array_of_vars['pw_rand_id'];
		//echo $pw_query;
		$paged = 1;
		$query = $pw_query;
		$query = explode('|', $query);

		$query_posts_per_page = 10;
		$query_post_type = 'post';
		$query_meta_key = '';
		$query_orderby = 'date';
		$query_order = 'ASC';

		$query_author_in = '';
		$query_author_not_in = '';

		foreach ($query as $query_part) {
			$q_part = explode(':', $query_part);
			switch ($q_part[0]) {
				case 'post_type':
					$query_post_type = explode(',', $q_part[1]);
					break;

				case 'size':
					$query_posts_per_page = ($q_part[1] == 'All' ? -1 : $q_part[1]);
					break;

				case 'order_by':

					$query_meta_key = '';
					$query_orderby = '';

					$public_orders_array = array('ID', 'date', 'author', 'title', 'modified', 'rand', 'comment_count', 'menu_order');
					if (in_array($q_part[1], $public_orders_array)) {
						$query_orderby = $q_part[1];
					} else {
						$query_meta_key = $q_part[1];
						$query_orderby = 'meta_value_num';
					}

					break;

				case 'order':
					$query_order = $q_part[1];
					break;

				case 'categories':
					$query_categories = explode(',', $q_part[1]);
					$query_cat_not_in = array();
					$query_cat_in = array();
					foreach ($query_categories as $cat) {
						if ($cat < 0) {
							$query_cat_not_in[] = abs($cat);
						} else {
							$query_cat_in[] = $cat;
						}
					}
					break;

				case 'tags':
					$query_tags = explode(',', $q_part[1]);
					$query_tags_not_in = array();
					$query_tags_in = array();
					foreach ($query_tags as $tags) {
						if ($tags < 0) {
							$query_tags_not_in[] = abs($tags);
						} else {
							$query_tags_in[] = $tags;
						}
					}
					break;

				case 'authors':
					$query_author = explode(',', $q_part[1]);
					$query_author_not_in = array();
					$query_author_in = array();
					foreach ($query_author as $author) {
						if ($author < 0) {
							$query_author_not_in[] = abs($author);
						} else {
							$query_author_in[] = $author;
						}
					}

					break;


				case 'tax_query':
					$all_tax = get_object_taxonomies($query_post_type);
					$tax_query = array();
					$query_tax_query = array('relation' => 'OR');
					foreach ($all_tax as $tax) {
						$values = $tax;
						$query_taxs_in = array();
						$query_taxs_not_in = array();

						$query_taxs = explode(',', $q_part[1]);
						foreach ($query_taxs as $taxs) {

							if ($taxs < 0) {
								$query_taxs_not_in[] = abs($taxs);
							} else {
								$query_taxs_in[] = $taxs;
							}
						}

						if (count($query_taxs_not_in) > 0) {
							$query_tax_query[] = array(
								'taxonomy' => $tax,
								'field' => 'id',
								'terms' => $query_taxs_not_in,
								'operator' => 'NOT IN',
							);
						} else if (count($query_taxs_in) > 0) {
							$query_tax_query[] = array(
								'taxonomy' => $tax,
								'field' => 'id',
								'terms' => $query_taxs_in,
								'operator' => 'IN',
							);
						}

					}

					break;
			}
		}

		$selected_cat = explode(",", $my_array_of_vars['cat_id']);
		$loop_var = array();
		$filter_items = '';
		if ($selected_cat[0] == 'no_cat') {

			if (($ticker_base == 'category_base') && (is_array($query_cat_in))) $loop_var = $query_cat_in;
			else if (($ticker_base == 'tag_base') && (is_array($query_tags_in))) $loop_var = $query_tags_in;
			else if (($ticker_base == 'author_base') && (is_array($query_author_in))) $loop_var = $query_author_in;
			else if (($ticker_base == 'tax_base') && (is_array($query_taxs_in))) $loop_var = explode(',', $q_part[1]);
			$filter_items = $loop_var;
		} else {
			if (($ticker_base == 'category_base') && (is_array($query_cat_in))) $loop_var = $selected_cat;
			else if (($ticker_base == 'tag_base') && (is_array($query_tags_in))) $loop_var = $selected_cat;
			else if (($ticker_base == 'author_base') && (is_array($query_author_in))) $loop_var = $selected_cat;
			else if (($ticker_base == 'tax_base') && (is_array($query_taxs_in))) $loop_var = $selected_cat;
			$filter_items = $loop_var;
		}
		/*Query Base Filter*/
		$query_final = '';
		if ((count($loop_var) > 0)) {
			$base_array = array();
			if ($ticker_base == 'category_base') $base_array = array('category__in' => $loop_var);
			else if ($ticker_base == 'tag_base') $base_array = array('tag__in' => $loop_var);
			else if ($ticker_base == 'author_base') $base_array = array('author__in' => $loop_var);
			else if ($ticker_base == 'tax_base') {
				$all_tax = get_object_taxonomies($query_post_type);
				$tax_query = array();
				$query_tax_query = array('relation' => 'OR');
				foreach ($all_tax as $tax) {
					$values = $tax;
					$query_taxs_in = array();
					$query_tax_query[] = array(
						'taxonomy' => $tax,
						'field' => 'id',
						'terms' => $loop_var,
						'operator' => 'IN',
					);
				}
				$base_array = array('tax_query' => $query_tax_query);
			}


			$query_final = array(
				'post_type' => $query_post_type,
				'post_status' => 'publish',
				'posts_per_page' => $query_posts_per_page,
				'meta_key' => $query_meta_key,
				'orderby' => $query_orderby,
				'order' => $query_order,

				'author__in' => $query_author_in,
				'author__not_in' => $query_author_not_in,
			);

			$query_final = array_merge($query_final, $base_array);
		}

		if ($ticker_base == 'all') {
			$query_final = array(
				'post_type' => $query_post_type,
				'post_status' => 'publish',
				'posts_per_page' => $query_posts_per_page,
				'meta_key' => $query_meta_key,
				'orderby' => $query_orderby,
				'order' => $query_order,
				//'paged'=>$paged,

				'post__in' => $query_by_id_in,
				'post__not_in' => $query_by_id_not_in,

				'category__in' => $query_cat_in,
				'category__not_in' => $query_cat_not_in,

				'tag__in' => $query_tags_in,
				'tag__not_in' => $query_tags_not_in,

				'author__in' => $query_author_in,
				'author__not_in' => $query_author_not_in,

				'tax_query' => $query_tax_query
			);
		}

		$height_style = '';
		if ($marquee_direction == 'up' || $marquee_direction == 'down') {
			$height_style = 'style="height:' . $marquee_height . 'px;"';
		}

		$output = '
		<div class="pl-slick-' . $rand_id . ' pl-slider-cnt " data-slider-id="' . $rand_id . '"  ' . $height_style . '>';

		global $pw_pro_news_ticker;
		$my_query = new WP_Query($query_final);
		$post_counter = 1;
		while ($my_query->have_posts()) {
			$my_query->the_post(); // Get post from query
			$post = new stdClass(); // Creating post object.
			$post->id = get_the_ID();
			$post->link = get_permalink($post->id);
			$post->title = get_the_title($post->id);
			$post->excerpt = get_the_excerpt();
			/*Get Taxonomy*/

			$cat_tax = array();
			$all_tax = get_object_taxonomies($query_post_type);
			$current_value = array();
			if (is_array($all_tax) && count($all_tax) > 0) {
				foreach ($all_tax as $tax) {
					if ($tax == "post_tag")
						continue;

					$cat = $pw_pro_news_ticker->get_category_tag($post->id, $tax, '', ',', '');
					if ($cat != '')
						$cat_tax[] = $cat;
				}//end foreach
			}//end if is_array($all_tax)
			if (is_array($cat_tax) && (count($cat_tax) > 0)) {
				$cat_tax = implode(',', $cat_tax);
				$cat_tax_array = explode(',', $cat_tax);
			}

			$post->author = get_the_author();
			$author_id = get_the_author_meta('ID');
			$author_link = get_author_posts_url($author_id);

			$excerpt_c = $post->excerpt;

			$comment_link = get_comments_link();
			$comment_num = get_comments_number('0', '1', '% responses');

			$img_id = get_post_meta($post->id, '_thumbnail_id', true);
			$img = array();
			$default_size = '';

			$full_img = wp_get_attachment_image_src($img_id, 'thumbnail');
			//$larg_img = wp_get_attachment_image_src( $img_id , $larg_thumb_size );
			//if post not set feature image read default image
			if ($full_img[0] == '') {
				$img = wp_get_attachment_image_src($default_image, 'thumbnail');
				$full_img[0] = $img[0];
			}


			if ($ticker_mode == 'pl-horizontal-ticker') {

				$output .= '
					<div class="pl-slider-slide"  >
						<div class="pl-ticker-content-item">
							
							<div class="pl-title">';
				if ($show_post_image == 'show_post_image') {
					$output .= '
									<div class="pl-ticker-img ' . $post_image_style . '">
										<a href="' . $post->link . '"><img src="' . $full_img[0] . '" class="slide-img" /> </a>
									</div>';
				}
				if ($show_date == 'yes') {
					$output .= '
									<div class="pl-date"><span>' . get_the_date($date_format) . '</span></div>';
				}
				if ($show_sharing == 'show_sharing') {
					$share_icon = explode(',', $social_icons);
					$output .= '
										<div class="pl-share-cnt">
											<i class="fa fa-share-alt"></i>
											<div class="pl-share-icons">';
					foreach ($share_icon as $icon) {
						switch ($icon) {
							case 'share_facebook':

								$output .= '
															<a href="https://www.facebook.com/sharer/sharer.php?u=' . $post->link . '"><i class="fa fa-facebook"></i></a>';
								break;
							case 'share_twitter':
								$output .= '
															<a href="https://twitter.com/share?url=' . $post->link . '"><i class="fa fa-twitter"></i></a>';
								break;

							case 'share_google':
								$output .= '
															<a href="https://plus.google.com/share?url=' . $post->link . '"><i class="fa fa-google-plus"></i></a>';
								break;
						}

					}//end foreach

					$output .= '
											</div>
										</div>	
									';
				}
				if ($show_quick == 'show_quick') {
					$output .= '
									<div class="pl-quick-cnt">
										<a class="quick-link-' . $rand_id . '" href="' . admin_url('admin-ajax.php') . '?action=pw_ticker_quick_view&post_id=' . $post->id . '"><i class="fa fa-file-text-o"></i></a>
									</div>';
				}

				$output .= '<a href="' . $post->link . '">' . $post->title . ' </a>
							</div><!--pl-title -->
						</div><!--pl-ticker-content-item -->
					</div><!--pl-slider-slide -->	';
			} else {
				$output .= '
				<div class="pl-slider-slide pl-vitem ' . $vertical_item_layout . '"  >
					<div class="pl-vitem-item">
								<div class="pl-thumbnail">
									<div class="pl-thumbnail-overlay">';

				if ($show_quick == 'show_quick') {
					$output .= '
											<div class="pl-zoom-quick-btn pl-circle-icon pl-center-center-fade">
												<a class="quick-link-' . $rand_id . '" href="' . admin_url('admin-ajax.php') . '?action=pw_ticker_quick_view&post_id=' . $post->id . '"><i class="fa fa-file-text-o"></i></a>
											</div>';
				}

				$output .= '
									</div>
									<div class="pl-thumbnail-img pl-zoomout">
										<a href="' . $post->link . '"><img src="' . $full_img[0] . '" class="slide-img" /> </a>
									</div>
								</div>
								<div class="pl-vitem-content">
									<div class="pl-title">';
				if ($show_sharing == 'show_sharing') {
					$share_icon = explode(',', $social_icons);
					$output .= '
												<div class="pl-share-cnt">
													<i class="fa fa-share-alt"></i>
													<div class="pl-share-icons">';
					foreach ($share_icon as $icon) {
						switch ($icon) {
							case 'share_facebook':

								$output .= '
																	<a href="https://www.facebook.com/sharer/sharer.php?u=' . $post->link . '"><i class="fa fa-facebook"></i></a>';
								break;
							case 'share_twitter':
								$output .= '
																	<a href="https://twitter.com/share?url=' . $post->link . '"><i class="fa fa-twitter"></i></a>';
								break;

							case 'share_google':
								$output .= '
																	<a href="https://plus.google.com/share?url=' . $post->link . '"><i class="fa fa-google-plus"></i></a>';
								break;
						}

					}//end foreach

					$output .= '
													</div>
												</div>	
											';
				}
				$output .= '
                                        <a href="' . $post->link . '">' . $post->title . ' </a>
									</div>';
				if ($show_meta == 'yes') {
					$output .= '	
										<div class="pl-meta">';

					if ($show_category == 'yes') {
						$output .= '
												<div class="pl-meta-item">
												<i class="fa fa-folder-o"></i>';
						for ($i = 0; $i < $cat_number; $i++) {
							if (isset($cat_tax_array[$i]))
								$output .= $cat_tax_array[$i] . '<div class="pl-meta-spil">,</div>';
						}//end for
						$output .= '
												 </div>';
					}//end if
					if ($show_date == 'yes') {
						$output .= '
												<span class="pl-meta-item">
													<i class="fa fa-clock-o"></i><span class="meta-text">' . get_the_date($date_format) . '</span>
												</span>
												';

					}
					if ($show_author == 'yes') {
						$output .= ' 
												<span class="pl-meta-item">
													<i class="fa fa-user"></i><a href="' . $author_link . '">' . $post->author . '</a>
												</span>
												';
					}
					if ($show_comments == 'yes') {
						$output .= '
												<span class="pl-meta-item">
													<i class="fa fa-comments"></i>
													<a href="' . $comment_link . '">' . $comment_num . '</a>
												</span>
												';
					}
					$output .= '	
										</div>';
				}//show meta
				if ($show_excerpt == 'yes') {
					$output .= ' 
										<div class="pl-excerpt">
											' . $pw_pro_news_ticker->excerpt($excerpt_c, $excerpt_len) . '
										</div>
										';
				}//end if
				$output .= '		
								</div>
							</div>
						</div>
				';

			}
			$post_counter++;
		}//end while 
		$output .= '</div>';
		echo $output;

		$new_post_author = wp_get_current_user();
		$new_post_date = current_time('timestamp');
		$new_post_date_gmt = get_gmt_from_date($new_post_date, 'H:i');
		$new_post_date_gmt = date("H : i", current_time('timestamp'));

		echo "@#" . $new_post_date_gmt;

		die();
	}
}
	
	//RSS FEED
if (!function_exists('pw_fetch_ticker_rss_items')) {
	add_action('wp_ajax_pw_fetch_ticker_rss_items', 'pw_fetch_ticker_rss_items');
	add_action('wp_ajax_nopriv_pw_fetch_ticker_rss_items', 'pw_fetch_ticker_rss_items');
	function pw_fetch_ticker_rss_items()
	{
		global $wpdb;

		parse_str($_REQUEST['postdata'], $my_array_of_vars);

		$nonce = $_POST['nonce'];

		if (!wp_verify_nonce($nonce, 'pl_news_ticker')) {
			$arr = array(
				'success' => 'no-nonce',
				'products' => array()
			);
			print_r($arr);
			die();
		}

		extract(shortcode_atts(array(
			'ticker_soure' => 'build_query',
			'ticker_base' => 'category_base',
			'pw_query' => '',
			'rss_source' => '',
			'rss_images' => '',
			'manual_source' => '',


			//ticker setting tab
			'ticker_mode' => 'pl-horizontal-ticker',
			'vertical_item_layout' => 'pl-vitem-layout-1',
			'ticker_height' => '50',
			'enable_interval' => 'disable_interval',
			'ticker_interval' => '10',
			'ticker_pos' => 'pl-current-wrapper',
			'hide_title' => 'show_title',
			'title_text' => 'Breaking News',
			'title_width' => '150',
			'title_icon' => 'fa-none',
			'show_filter' => 'hide_filter',

			'show_author_image' => 'hide_author_image',
			'show_time' => 'pl-timer-disable',
			'show_toggle' => 'hide_toggle',
			'show_post_image' => 'hide_post_image',
			'post_image_style' => 'pl-round-img',
			'default_image' => '',

			'show_date' => 'hide_date',
			'date_format' => 'j F Y',

			'show_sharing' => 'hide_date',
			'social_icons' => '',

			'show_quick' => 'hide_quick',
			'quick_effect' => 'fade-in-scale',

			'show_meta' => 'no',
			'show_author' => 'no',
			'show_comments' => 'no',
			'show_category' => 'no',
			'cat_number' => '1',

			'show_excerpt' => 'no',
			'excerpt_source' => 'excerpt',
			'excerpt_len' => '20',


			//carousel setting
			'carousel_effect' => 'slide',
			'marquee_direction' => 'left',
			'scroll_amount' => '20',
			'marquee_height' => '200',
			'show_navigation' => 'pl-ticker-hide-nav',
			'auto_speed' => '2000',
			'trans_speed' => '500',
			'item_per_show' => '3',
			'item_per_slide' => '1',


			//Style Tab
			'ticker_style' => 'predefine',
			'predefine_pattern' => 'pl-pre-1',

			'ticker_border' => '0,0,0,0,solide,#dddddd',

			'title_background' => '#444444',
			'title_font' => 'inherit,15,#ffffff',
			'title_layout' => 'pl-ticker-title-l1',

			'clock_background' => '#333333',
			'clock_font' => 'inherit,15,#f5f5f5',

			'content_background' => '#777777',
			'content_font' => 'inherit,15,#f5f5f5,#f5f5f5',
			'meta_font' => 'inherit,11,#f5f5f5,#f5f5f5',
			'icon_background' => '#444444',
			'icon_color' => '#ffffff',

			'custom_css' => '',
		), json_decode($my_array_of_vars['pw_atts'])));
		$rss_sources = explode(',', $rss_source);
		//print_r(json_decode($my_array_of_vars['pw_atts']));

		$rand_id = $my_array_of_vars['pw_rand_id'];

		global $pw_pro_news_ticker;
		$selected_rss = explode(",", $my_array_of_vars['rss_id']);

		$height_style = '';
		if ($marquee_direction == 'up' || $marquee_direction == 'down') {
			$height_style = 'style="height:' . $marquee_height . 'px;"';
		}

		$output = '
		<div class="pl-slick-' . $rand_id . ' pl-slider-cnt " data-slider-id="' . $rand_id . '"  ' . $height_style . '>';

		$k = 0;
		//print_r($selected_rss);

		foreach ($rss_sources as $source) {

			if (!in_array($k, $selected_rss) && $selected_rss[0] != 'no_rss') {
				$k++;
				continue;
			}
			$k++;
			$source_detail = explode('|', $source);

			$rss = fetch_feed($source_detail[1]);
			$maxitems = 0;
			if (!is_wp_error($rss)) : // Checks that the object is created correctly
				// Figure out how many total items there are, but limit it to 5. 
				$max_items = isset($source_detail[2]) ? $source_detail[2] : 5;
				$maxitems = $rss->get_item_quantity($max_items);
				// Build an array of all the items, starting with element 0 (first element).
				$rss_items = $rss->get_items(0, $maxitems);
			endif;
			if ($maxitems == 0) :
				$output .= '
				<div class="pl-slider-slide"  >' . _e('No items', 'my-text-domain') . '</div>';
			else :

				foreach ($rss_items as $item) :
					$pl_excerpt = $item->get_description();
					$pl_excerpt = wp_html_excerpt($pl_excerpt, intval($excerpt_len));

					/*IMAGES*/
					$pl_output = preg_match_all('/<img[^>]+src=[\'"]([^\'"]+)[\'"][^>]*>/i', $item->get_description(), $pl_matches);
					$pl_thumbnail = '';
					if (is_array($pl_matches[1]) && count($pl_matches[1]) > 0) {
						$pl_thumbnail = $pl_matches[1][0];
					} else {
						$full_img = wp_get_attachment_image_src($default_image, 'thumbnail');
						$pl_thumbnail = $full_img[0];
					}
					$pl_date = $item->get_date($date_format);
					$pl_title = esc_html($item->get_title());
					$pl_link = esc_url($item->get_permalink());
					//$pl_author = $item->get_author()->get_name();
					$pl_author = '';
					if ($ticker_mode == 'pl-horizontal-ticker') {
						$output .= '
							<div class="pl-slider-slide"  >
								<div class="pl-ticker-content-item">
									
									<div class="pl-title">';
						if ($show_post_image == 'show_post_image') {
							$output .= '
											<div class="pl-ticker-img ' . $post_image_style . '">
												<a href="' . $pl_link . '"><img src="' . $pl_thumbnail . '" class="slide-img" /> </a>
											</div>';
						}
						if ($show_date == 'yes') {
							$output .= '
											<div class="pl-date"><span>' . $pl_date . '</span></div>';
						}
						if ($show_sharing == 'show_sharing') {
							$share_icon = explode(',', $social_icons);
							$output .= '
												<div class="pl-share-cnt">
													<i class="fa fa-share-alt"></i>
													<div class="pl-share-icons">';
							foreach ($share_icon as $icon) {
								switch ($icon) {
									case 'share_facebook':

										$output .= '
																	<a href="https://www.facebook.com/sharer/sharer.php?u=' . $pl_link . '"><i class="fa fa-facebook"></i></a>';
										break;
									case 'share_twitter':
										$output .= '
																	<a href="https://twitter.com/share?url=' . $pl_link . '"><i class="fa fa-twitter"></i></a>';
										break;

									case 'share_google':
										$output .= '
																	<a href="https://plus.google.com/share?url=' . $pl_link . '"><i class="fa fa-google-plus"></i></a>';
										break;
								}

							}//end foreach

							$output .= '
													</div>
												</div>	
											';
						}


						$output .= '<a href="' . $pl_link . '">' . $pl_title . ' </a>
									</div><!--pl-title -->
								</div><!--pl-ticker-content-item -->
							</div><!--pl-slider-slide -->	';
					} else {
						$output .= '
						<div class="pl-slider-slide pl-vitem ' . $vertical_item_layout . '"  >
							<div class="pl-vitem-item">
										<div class="pl-thumbnail">
											<div class="pl-thumbnail-overlay">';
						$output .= '
											</div>
											<div class="pl-thumbnail-img pl-zoomout">
												<a href="' . $pl_link . '"><img src="' . $pl_thumbnail . '" class="slide-img" /> </a>
											</div>
										</div>
										<div class="pl-vitem-content">
											<div class="pl-title">';
						if ($show_sharing == 'show_sharing') {
							$share_icon = explode(',', $social_icons);
							$output .= '
														<div class="pl-share-cnt">
															<i class="fa fa-share-alt"></i>
															<div class="pl-share-icons">';
							foreach ($share_icon as $icon) {
								switch ($icon) {
									case 'share_facebook':

										$output .= '
																			<a href="https://www.facebook.com/sharer/sharer.php?u=' . $pl_link . '"><i class="fa fa-facebook"></i></a>';
										break;
									case 'share_twitter':
										$output .= '
																			<a href="https://twitter.com/share?url=' . $pl_link . '"><i class="fa fa-twitter"></i></a>';
										break;

									case 'share_google':
										$output .= '
																			<a href="https://plus.google.com/share?url=' . $pl_link . '"><i class="fa fa-google-plus"></i></a>';
										break;
								}

							}//end foreach

							$output .= '
															</div>
														</div>	
													';
						}
						$output .= '
												<a href="' . $pl_link . '">' . $pl_title . ' </a>
											</div>';
						if ($show_meta == 'yes') {
							$output .= '	
												<div class="pl-meta">';
							if ($show_author == 'yes') {
								$output .= ' 
														<span class="pl-meta-item">
															<i class="fa fa-user"></i><span class="meta-text">' . $pl_author . '</span>
														</span>
														';
							}
							if ($show_date == 'yes') {
								$output .= '
														<span class="pl-meta-item">
															<i class="fa fa-clock-o"></i><span class="meta-text">' . $pl_date . '</span>
														</span>
														';

							}
							$output .= '	
												</div>';
						}//show meta
						if ($show_excerpt == 'yes') {
							$output .= ' 
												<div class="pl-excerpt">
													' . $pl_excerpt . '
												</div>
												';
						}//end if
						$output .= '		
										</div>
									</div>
								</div>
						';

					}


				endforeach;
			endif;
		}//end foreach sources

		$output .= '</div>';
		echo $output;

		die();
	}
}

if (!function_exists('pw_ticker_quick_view')) {

	add_action('wp_ajax_pw_ticker_quick_view', 'pw_ticker_quick_view');
	add_action('wp_ajax_nopriv_pw_ticker_quick_view', 'pw_ticker_quick_view');
	function pw_ticker_quick_view()
	{
		global $wpdb, $pw_general_ad_main_class, $post, $woocommerce;


		$product_id = $_GET['post_id'];
		$post_id = $id = $_GET['post_id'];
		$post_name = get_post_type($product_id);
		$product_slide = '';

		$postd = get_post($post_id);

		$excerpt = $postd->post_content;
		if ($excerpt == '')
			$excerpt = $postd->post_excerpt;


		$title = $postd->post_title;
		$permalink = get_permalink($post_id);

		$post_date = get_the_time('Y-m-d', $post_id);

		$post_author = get_the_author();

		$author_id = $postd->post_author;
		$author_name = get_the_author_meta('display_name', $author_id);
		$author_link = get_author_posts_url($author_id);


		$comment_link = get_comments_link();
		$comment_num = get_comments_number('0', '1', '% responses');


		$cat = array();
		$category = get_the_category($post_id);
		//if($category[0]){
		foreach ($category as $catt) {
			$cat[] = '<a href="' . get_category_link($catt->term_id) . '">' . $catt->cat_name . '</a>';
		}

		$tag = array();
		$tags = wp_get_post_tags($post_id);
		foreach ($tags as $tagg) {
			$tag[] = '<a href="' . get_tag_link($tagg->term_id) . '">' . $tagg->name . '</a>';
		}
		if (is_array($tag))
			$tag = implode(' / ', $tag);

		$thumbnail_id = get_post_thumbnail_id($post_id);
		//Featured Image with size
		$src_featured = wp_get_attachment_image_src($thumbnail_id, 'large');

		$thumb_index = 0;
		$img_url = array();
		$img_url_default = '';

		if ($src_featured == '') {
			//$img=wp_get_attachment_image_src( $default_image,'full' );			
			$src_featured[0] = '';
		}


		echo '<div class="pl-quick-popup" >
				<img src="' . (isset($src_featured[0]) ? $src_featured[0] : "") . '">
				<div class="pl-popup-content">
					<div class="pl-title">
						<a href="' . $permalink . '">' . $title . '</a>
					</div>
					<div class="pl-meta">
						<span class="pl-meta-item"><i class="fa fa-folder-o"></i>' . implode('<div class="pl-meta-spil">,</div>', $cat) . '
						
						</span>
						<span class="pl-meta-item"><i class="fa fa-user"></i><a href="' . $author_link . '">' . $author_name . '</a></span>
						<span class="pl-meta-item"><i class="fa fa-comments"></i><a href="' . $comment_link . '">' . $comment_num . '</a><span>
						<span class="pl-meta-item"><i class="fa fa-clock-o"></i><span class="meta-text">' . $post_date . '</span></span>
					</div>';

		echo '	
					<div class="pl-excerpt">
						' . do_shortcode($excerpt) . '
					</div>
				</div><!--pl-popup-content -->
			</div>';

		die();
	}
}
?>